/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import com.hrznstudio.titanium._impl.TagConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class TagUtil {
    public static <T extends ForgeRegistryEntry<T>> boolean hasTag(IForgeRegistry<T> registry, T type, TagKey<T> tag) {
        return registry.tags().getTag(tag).contains(type);
    }

    public static ITagManager<Block> getAllBlockTags() {
        return ForgeRegistries.BLOCKS.tags();
    }

    public static ITagManager<Item> getAllItemTags() {
        return ForgeRegistries.ITEMS.tags();
    }

    public static ITagManager<Fluid> getAllFluidTags() {
        return ForgeRegistries.FLUIDS.tags();
    }

    public static <T extends ForgeRegistryEntry<T>> Collection<T> getAllEntries(IForgeRegistry<T> registry, TagKey<T> ... tags) {
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        if (tags.length == 1) {
            return registry.tags().getTag(tags[0]).stream().toList();
        }
        ArrayList list = new ArrayList();
        for (TagKey<T> tag : tags) {
            list.addAll(registry.tags().getTag(tag).stream().toList());
        }
        return list;
    }

    public static <T extends ForgeRegistryEntry<T>> Collection<T> getAllEntries(IForgeRegistry<T> registry, TagKey<T> tag) {
        return registry.tags().getTag(tag).stream().toList();
    }

    public static <T extends ForgeRegistryEntry<T>> TagKey<T> getOrCreateTag(IForgeRegistry<T> registry, ResourceLocation resourceLocation) {
        return registry.tags().createTagKey(resourceLocation);
    }

    public static TagKey<Item> getItemTag(ResourceLocation resourceLocation) {
        return ForgeRegistries.ITEMS.tags().stream().filter(items -> items.getKey().f_203868_().equals((Object)resourceLocation)).map(ITag::getKey).findFirst().orElse(TagUtil.getOrCreateTag(ForgeRegistries.ITEMS, resourceLocation));
    }

    public static TagKey<Block> getBlockTag(ResourceLocation resourceLocation) {
        return ForgeRegistries.BLOCKS.tags().stream().filter(items -> items.getKey().f_203868_().equals((Object)resourceLocation)).map(ITag::getKey).findFirst().orElse(TagUtil.getOrCreateTag(ForgeRegistries.BLOCKS, resourceLocation));
    }

    public static TagKey<EntityType<?>> getEntityTypeTag(ResourceLocation resourceLocation) {
        return ForgeRegistries.ENTITIES.tags().stream().filter(items -> items.getKey().f_203868_().equals((Object)resourceLocation)).map(ITag::getKey).findFirst().orElse(TagUtil.getOrCreateTag(ForgeRegistries.ENTITIES, resourceLocation));
    }

    public static TagKey<Fluid> getFluidTag(ResourceLocation resourceLocation) {
        return ForgeRegistries.FLUIDS.tags().stream().filter(items -> items.getKey().f_203868_().equals((Object)resourceLocation)).map(ITag::getKey).findFirst().orElse(TagUtil.getOrCreateTag(ForgeRegistries.FLUIDS, resourceLocation));
    }

    public static ItemStack getItemWithPreference(TagKey<Item> tagKey) {
        ITag item = ForgeRegistries.ITEMS.tags().getTag(tagKey);
        if (item.isEmpty()) {
            return ItemStack.f_41583_;
        }
        List elements = item.stream().toList();
        for (String modid : TagConfig.ITEM_PREFERENCE) {
            for (Item allElement : elements) {
                if (!allElement.getRegistryName().m_135827_().equalsIgnoreCase(modid)) continue;
                return new ItemStack((ItemLike)allElement);
            }
        }
        return new ItemStack((ItemLike)elements.get(0));
    }
}

